<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "invoices";
	$page_no = 1;
	$next_page = $prev_page = $html_str = $status = $status_options = "";
	
	if( isset($_GET) && isset($_GET['page_no']) && intval($_GET['page_no']) > 0 ){
		$page_no = intval($_GET['page_no']);
	}
	
	if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
		$status = $_GET['status'];
	}
	
	$status_options .= ($status=="") ? '<option value="" selected>All</option>' : '<option value="">All</option>';
	$status_options .= ($status=="draft") ? '<option value="draft" selected>Draft</option>' : '<option value="draft">Draft</option>';
	$status_options .= ($status=="overdue") ? '<option value="overdue" selected>Overdue</option>' : '<option value="overdue">Overdue</option>';
	$status_options .= ($status=="paid") ? '<option value="paid" selected>Paid</option>' : '<option value="paid">Paid</option>';
	$status_options .= ($status=="partially_paid") ? '<option value="partially_paid" selected>Partially Paid</option>' : '<option value="partially_paid">Partially Paid</option>';
	$status_options .= ($status=="sent") ? '<option value="sent" selected>Sent</option>' : '<option value="sent">Sent</option>';
	$status_options .= ($status=="unpaid") ? '<option value="unpaid" selected>Unpaid</option>' : '<option value="unpaid">Unpaid</option>';
	$status_options .= ($status=="viewed") ? '<option value="viewed" selected>Viewed</option>' : '<option value="viewed">Viewed</option>';
	$status_options .= ($status=="void") ? '<option value="void" selected>Void</option>' : '<option value="void">Void</option>';
	
	$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
	$config = array(
					"customer_id" => $_SESSION['contact_id'],
					"page" => $page_no,
				);
	
	if( $status != "" ){
		$config["status"] = $status;
	}

	$invoices = $zb->allInvoices($config);
	
	echo "<pre>";
	print_r($invoices);
	echo "</pre>";

	$response = json_decode($invoices, true);
	
	if( is_array($response) ){
		$invoices = $response['invoices'];
		$page_context = $response['page_context'];
		$max = sizeof($invoices);
		
		/*echo "<pre>";
		print_r($invoices[0]);
		echo "</pre>";
		
		echo "<pre>";
		print_r($page_context);
		echo "</pre>";*/
		
		for($i=0; $i<$max; $i++){
			$status_class = "badge-primary";
		
			if( $invoices[$i]['status'] == "draft" ){
				$status_class = "badge-secondary";
			}else if( $invoices[$i]['status'] == "overdue" ){
				$status_class = "badge-warning";
			}else if( $invoices[$i]['status'] == "paid" ){
				$status_class = "badge-success";
			}else if( $invoices[$i]['status'] == "partially_paid" ){
				$status_class = "badge-info";
			}else if( $invoices[$i]['status'] == "sent" ){
				$status_class = "badge-info";
			}else if( $invoices[$i]['status'] == "unpaid" ){
				$status_class = "badge-primary";
			}else if( $invoices[$i]['status'] == "viewed" ){
				$status_class = "badge-primary";
			}else if( $invoices[$i]['status'] == "void" ){
				$status_class = "badge-primary";
			}
			
			$html_str .= '<div class="card mb-2">
								<div class="card-body">
									<div class="d-sm-flex row flex-wrap text-sm-left align-items-center">
										<div class="col-6 text-left">
											<a href="download.php?invoice_id='. $invoices[$i]['invoice_id'] .'&invoice_number='. $invoices[$i]['invoice_number'] .'" target="_blank">
												<h4 class="text-info">'. $invoices[$i]['invoice_number'] .'</h4>
											</a>
											<h6>Date: <span class="text-muted">'. date('d-M-Y', strtotime($invoices[$i]['date'])) .'</span></h6>
											<h6 class="m-0">Due: <span class="text-muted">'. date('d-M-Y', strtotime($invoices[$i]['due_date'])) .'</span></h6>
										</div>
										<div class="col-6 text-right">
											<h4 class="text-primary">'. $invoices[$i]['total'] .' <i class="fa fa-rupee"></i></h4>
											<h6 class="m-0"><span class="badge '. $status_class .'">'. ucfirst($invoices[$i]['status']) .'</span></h6>
										</div>
									</div>
								</div>
							</div>';
		}
		
		if( $page_no > 1 ){
			$prev_page = "invoices.php?page_no=" . ($page_no - 1);
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$prev_page .= "&status=" . $_GET['status'];
			}
		}
		
		if( $page_context['has_more_page'] ){
			$page_no++;
			
			$next_page = "invoices.php?page_no=" . $page_no;
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$next_page .= "&status=" . $_GET['status'];
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">Invoices</h3>
				</div>
				<div>
					<div class="d-flex align-items-center">
						<select class="form-control" id="statusFltr">
							<?php echo $status_options; ?>
						</select>
					</div>
				</div>
			</div>
			<hr>
			<?php echo $html_str; ?>
			
			<?php if( (isset($prev_page) && $prev_page != "") || (isset($next_page) && $next_page != "") ){ ?>
			<div class="row mt-4">
				<div class="col-auto">
					<?php if(isset($prev_page) && $prev_page != ""){ ?>
					<a href="<?php echo $prev_page; ?>" class="btn btn-inverse-dark btn-fw">Previous</a>
					<?php } ?>
				</div>
				<div class="col"></div>
				<div class="col-auto">
					<?php if(isset($next_page) && $next_page != ""){ ?>
					<a href="<?php echo $next_page; ?>" class="btn btn-inverse-dark btn-fw">Next</a>
					<?php } ?>
				</div>
			</div>
			<?php }?>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    